CREATE TABLE SEMESTRE (
  CODIGO INTEGER  NOT NULL  ,
  DESCRICAO VARCHAR(20)    ,
  DATA_INICIO DATE    ,
  DATA_FIM DATE      ,
PRIMARY KEY(CODIGO));



CREATE TABLE CURSO (
  CODIGO INTEGER  NOT NULL  ,
  SEMESTRE_CODIGO INTEGER  NOT NULL  ,
  DESCRICAO VARCHAR(45)    ,
  TURNO VARCHAR(20)    ,
  DIASLETIVO INTEGER    ,
  COORDENADOR VARCHAR(45)      ,
PRIMARY KEY(CODIGO)  ,
  FOREIGN KEY(SEMESTRE_CODIGO)
    REFERENCES SEMESTRE(CODIGO)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION);


CREATE INDEX CURSO_FKIndex1 ON CURSO (SEMESTRE_CODIGO);



CREATE TABLE MODULO (
  CODIGO INTEGER  NOT NULL  ,
  CURSO_CODIGO INTEGER  NOT NULL  ,
  DESCRICAO VARCHAR(45)    ,
  QTDALUNOS INTEGER      ,
PRIMARY KEY(CODIGO)  ,
  FOREIGN KEY(CURSO_CODIGO)
    REFERENCES CURSO(CODIGO)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION);


CREATE INDEX MODULO_FKIndex1 ON MODULO (CURSO_CODIGO);



CREATE TABLE UNICURRIC (
  CODIGO INTEGER  NOT NULL  ,
  MODULO_CODIGO INTEGER  NOT NULL  ,
  DESCRICAO VARCHAR(45)    ,
  HORASAULA REAL      ,
PRIMARY KEY(CODIGO)  ,
  FOREIGN KEY(MODULO_CODIGO)
    REFERENCES MODULO(CODIGO)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION);


CREATE INDEX UNICURRIC_FKIndex1 ON UNICURRIC (MODULO_CODIGO);




